<?php
session_start();
include 'db.php';
if (!isset($_SESSION['user_id']) || !$_SESSION['is_seller']) { header("Location: /login"); exit; }
$seller_id = (int) $_SESSION['user_id'];
$errors = []; $success = '';

// mark expired
$conn->query("UPDATE products SET status = 0 WHERE expiry_at <= NOW() AND status = 1");

// get upload limit
$upload_limit = 5;
$stmt = $conn->prepare("SELECT upload_limit FROM registration WHERE id = ?");
if ($stmt) {
    $stmt->bind_param("i", $seller_id);
    $stmt->execute();
    $stmt->bind_result($limit_db);
    if ($stmt->fetch() && is_numeric($limit_db)) $upload_limit = (int)$limit_db;
    $stmt->close();
}

// active count
$current_count = 0;
$stmt = $conn->prepare("SELECT COUNT(*) FROM products WHERE seller_id = ? AND status = 1");
if ($stmt) {
    $stmt->bind_param("i", $seller_id);
    $stmt->execute();
    $stmt->bind_result($current_count);
    $stmt->fetch();
    $stmt->close();
}

// delete product
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_product']) && is_numeric($_POST['delete_product'])) {
    $del_id = (int) $_POST['delete_product'];
    $stmt = $conn->prepare("SELECT image_url FROM products WHERE id = ? AND seller_id = ?");
    $stmt->bind_param("ii", $del_id, $seller_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $row = $res->fetch_assoc();
    $stmt->close();
    if ($row) {
        $file = __DIR__ . '/' . $row['image_url'];
        if (file_exists($file)) @unlink($file);
        $stmt = $conn->prepare("DELETE FROM products WHERE id = ? AND seller_id = ?");
        $stmt->bind_param("ii", $del_id, $seller_id);
        $stmt->execute();
        $stmt->close();
        $_SESSION['supload_msg'] = "Product deleted.";
        header("Location: " . $_SERVER['PHP_SELF']); exit;
    } else {
        $errors[] = "Product not found or you don't have permission to delete it.";
    }
}

// handle upload (kept largely same; omitted for brevity — keep your existing robust code here)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['name']) && !isset($_POST['delete_product'])) {
    // copy your existing upload logic from old supload.php here (image compression, validation, insert)
    // ensure you re-check current_count >= upload_limit before inserting
    // set $success = "Product added..." and redirect as before
}

// fetch seller products
$products = [];
$stmt = $conn->prepare("SELECT id, name, sale_price, image_url, expiry_at, status, created_at FROM products WHERE seller_id = ? ORDER BY created_at DESC");
$stmt->bind_param("i", $seller_id);
$stmt->execute();
$res = $stmt->get_result();
while ($p = $res->fetch_assoc()) $products[] = $p;
$stmt->close();

// fetch comments for products (optional — you already did above in original code)
$commentsByProduct = [];
if (!empty($products)) {
    $ids = array_column($products, 'id');
    $placeholders = implode(',', array_fill(0, count($ids), '?'));
    $types = str_repeat('i', count($ids));
    // build dynamic query
    $sql = "SELECT id, product_id, viewer_name, viewer_phone, comment, created_at FROM product_responses WHERE product_id IN ($placeholders) ORDER BY created_at DESC";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param($types, ...$ids);
    $stmt->execute();
    $res2 = $stmt->get_result();
    while ($c = $res2->fetch_assoc()) {
        $pid = $c['product_id'];
        if (!isset($commentsByProduct[$pid])) $commentsByProduct[$pid] = [];
        $commentsByProduct[$pid][] = $c;
    }
    $stmt->close();
}

// session message
if (isset($_SESSION['supload_msg'])) { $success = $_SESSION['supload_msg']; unset($_SESSION['supload_msg']); }
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Seller Product Upload</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background:#f8f9fa; }
.container { max-width:1000px; margin:20px auto; }
.product-card { background:#fff; border-radius:10px; padding:15px; margin-bottom:20px; box-shadow:0 3px 10px rgba(0,0,0,0.06); display:flex; gap:15px; align-items:flex-start;}
.product-img { width:150px; height:120px; object-fit:cover; border-radius:8px; }
.small-muted { font-size:0.85rem; color:#666; }
@media (max-width:767px) {
  .product-card { flex-direction:column; align-items:stretch; }
  .product-img { width:100%; height:auto; max-height:300px; }
}
</style>
</head>
<body>
<div class="container">
  <div class="card p-3 mb-3">
    <div class="d-flex gap-2 align-items-center mb-2">
      <h4 class="mb-0">Add New Product</h4>
      <a href="messages.php" class="btn btn-outline-secondary btn-sm ms-auto">📨 View Messages</a>
    </div>

    <?php if($errors): ?>
      <div class="alert alert-danger"><?= htmlspecialchars(implode('<br>', $errors)) ?></div>
    <?php endif; ?>
    <?php if($success): ?>
      <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
    <?php endif; ?>

    <div class="mb-2 text-muted">Your upload limit: <strong><?= $upload_limit ?></strong> — Active products: <strong><?= $current_count ?></strong></div>

    <form id="uploadForm" method="post" enctype="multipart/form-data">
      <div class="row g-2">
        <div class="col-md-6">
          <input type="text" name="name" class="form-control" placeholder="Product Name" required <?= ($current_count >= $upload_limit) ? 'disabled' : '' ?>>
        </div>
        <div class="col-md-3">
          <input type="number" step="0.01" name="sale_price" class="form-control" placeholder="Sale Price" required <?= ($current_count >= $upload_limit) ? 'disabled' : '' ?>>
        </div>
        <div class="col-md-3">
          <input type="file" name="image" class="form-control" accept="image/*" required <?= ($current_count >= $upload_limit) ? 'disabled' : '' ?>>
        </div>
      </div>
      <?php if ($current_count >= $upload_limit): ?>
        <div class="alert alert-warning mt-2">You have reached your upload limit of <?= $upload_limit ?> active products. Delete some products to upload more.</div>
      <?php endif; ?>
      <div class="mt-2">
        <button class="btn btn-primary" <?= ($current_count >= $upload_limit) ? 'disabled' : '' ?>>Add Product</button>
      </div>
    </form>
  </div>

  <?php if (empty($products)): ?>
    <div class="alert alert-info">No products yet.</div>
  <?php else: ?>
    <?php foreach ($products as $prod): ?>
      <div class="product-card">
        <img src="<?= htmlspecialchars($prod['image_url'] ?: 'uploads/default.png') ?>" class="product-img" alt="">
        <div class="flex-fill">
            <div class="d-flex align-items-start justify-content-between">
                <div>
                  <h5 class="mb-1"><?= htmlspecialchars($prod['name']) ?></h5>
                  <div class="small-muted">Price: <?= number_format((float)$prod['sale_price'],2) ?> • Status: <?= $prod['status']==1 ? 'Active' : 'Inactive' ?></div>
                </div>
                <div class="text-end">
                  <form method="post" onsubmit="return confirm('Delete this product?');">
                    <input type="hidden" name="delete_product" value="<?= (int)$prod['id'] ?>">
                    <button class="btn btn-sm btn-danger mb-1">Delete</button>
                  </form>
                  <a class="btn btn-sm btn-outline-primary" href="messages.php?start=<?= (int)$prod['id'] ?>">Messages</a>
                </div>
            </div>

            <?php $comments = $commentsByProduct[$prod['id']] ?? []; ?>
            <?php if ($comments): ?>
              <div class="mt-3">
                <strong>Comments (<?= count($comments) ?>)</strong>
                <ul class="list-group list-group-flush mt-2">
                  <?php foreach ($comments as $c): ?>
                    <li class="list-group-item">
                      <strong><?= htmlspecialchars($c['viewer_name']) ?></strong> (<?= htmlspecialchars($c['viewer_phone']) ?>): 
                      <?= htmlspecialchars($c['comment']) ?>
                      <div class="mt-1 small-muted"><?= $c['created_at'] ?></div>
                      <div class="mt-1">
                        <a href="messages.php?start=<?= (int)$prod['id'] ?>&receiver=<?= (int)$seller_id ?>" class="btn btn-sm btn-outline-secondary">Open Chat</a>
                        <!-- Optional: add form to reply publicly -->
                      </div>
                    </li>
                  <?php endforeach; ?>
                </ul>
              </div>
            <?php endif; ?>

        </div>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>
</div>
</body>
</html>
