<?php
session_start();
include 'db.php';

// --- AUTO-BASE DETECTION ---
$base_folder = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/');
function base_url($path = '') {
    global $base_folder;
    return $base_folder . '/' . ltrim($path, '/');
}
// Auto mark expired
$conn->query("UPDATE products SET status=0 WHERE expiry_at <= NOW() AND status=1");
// --- END AUTO-BASE DETECTION ---

$logged_in = isset($_SESSION['user_id']);
$user_name = $_SESSION['user_name'] ?? '';
$is_seller = $_SESSION['is_seller'] ?? 0;

// Fetch sellers with active products (random)
$sellers = [];
$res = $conn->query("
    SELECT r.id, r.name 
    FROM registration r
    WHERE r.is_seller = 1 
      AND r.seller_active = 1
      AND EXISTS (SELECT 1 FROM products p WHERE p.seller_id = r.id AND p.status = 1)
    ORDER BY RAND()
");

while ($seller = $res->fetch_assoc()) {

    // Fetch active products for this seller (random order)
    $products = [];
    $stmt = $conn->prepare("
        SELECT id, name, sale_price, image_url 
        FROM products 
        WHERE seller_id = ? AND status = 1 
        ORDER BY RAND()
    ");
    $stmt->bind_param("i", $seller['id']);
    $stmt->execute();
    $result = $stmt->get_result();

    while ($p = $result->fetch_assoc()) {
        $products[] = $p;
    }
    $stmt->close();

    if (!empty($products)) {
        $seller['products'] = $products;
        $sellers[] = $seller;
    }
}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Product Gallery</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.css" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">

<style>
body { background:#f8f9fa; margin:0; padding:0; }
.swiper { width:100%; height:100vh; }
.product-card { background:#fff; border-radius:0.5rem; padding:0.5rem; text-align:center; }
.product-card img { width:100%; max-height:300px; object-fit:cover; border-radius:0.5rem; }
.comment-box { margin-top:0.5rem; }
.category-title { font-weight:bold; font-size:1.1rem; margin-bottom:0.5rem; }
.login-prompt { background:#fff; padding:1rem; border-radius:0.5rem; text-align:center; }
body { padding-top: 0; } /* if needed, adjust based on header height */
@media (max-width:576px){
    #galleryHeader { flex-direction: column; align-items: flex-start; }
    #galleryHeader a { margin-top:5px; }
}

.small-round-btn {
    width: 34px;
    height: 34px;
    border-radius: 50%;
    background: #0d6efd;
    color: #fff;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 16px;
    text-decoration: none;
}

.small-round-btn:nth-of-type(2) {
    background: #6c757d;
}

.login-title {
    font-size: 15px;
    font-weight: 500;
    white-space: nowrap;
}

#lightboxOverlay {
    position: fixed;
    display: none;
    top:0; left:0;
    width:100%; height:100%;
    background: rgba(0,0,0,0.85);
    z-index: 2000;
    justify-content:center;
    align-items:center;
}
#lightboxOverlay img {
    max-width:90%;
    max-height:90%;
    border-radius:8px;
    box-shadow: 0 0 15px #000;
}
#lightboxOverlay .close-btn {
    position:absolute;
    top:20px;
    right:20px;
    font-size:32px;
    color:white;
    cursor:pointer;
    font-weight:bold;
    user-select:none;
}


</style>
</head>
<body>
    
    <!-- LIGHTBOX OVERLAY -->
<!-- LIGHTBOX -->



    
<div style="display:flex; align-items:center; justify-content:space-between; white-space:nowrap; width:100%; padding:0.5rem 1rem; background:#007bff; color:white; position:sticky; top:0; z-index:1000;">

    <!-- LEFT: Logo + Text -->
    <div style="display:flex; align-items:center; gap:0.5rem; flex-shrink:1; min-width:0;">
        <img src="islogo.png" alt="Logo" style="height:30px; width:auto; flex-shrink:0;">
        <span style="font-weight:bold; overflow:hidden; text-overflow:ellipsis; white-space:nowrap;">
            InstaSell
        </span>
    </div>

    <!-- RIGHT: Button -->
    <a href="messages.php" style="flex-shrink:0; white-space:nowrap; padding:0.25rem 0.5rem; background:white; color:#007bff; border-radius:4px; text-decoration:none; font-size:0.875rem;">
        Back
    </a>

</div>







<div class="container py-3">

<?php if (!$logged_in): ?>
    <div class="login-prompt d-flex align-items-center gap-2 mb-3">

    <a href="<?= base_url('login') ?>" class="small-round-btn">
        <i class="bi bi-box-arrow-in-right"></i>
    </a>

    <a href="<?= base_url('register') ?>" class="small-round-btn">
        <i class="bi bi-person-plus"></i>
    </a>

    <span class="login-title ms-2">Login or Register to Comment</span>

</div>


<?php endif; ?>

<div class="swiper verticalSwiper">
    <div class="swiper-wrapper">

        <?php foreach ($sellers as $seller): ?>
        <div class="swiper-slide">
            <div class="container py-3">

                <!-- SELLER NAME -->
                <div class="category-title">
                    <?= htmlspecialchars($seller['name']) ?>
                </div>

                <div class="swiper horizontalSwiper">
                    <div class="swiper-wrapper">

                        <?php foreach ($seller['products'] as $p):
                            // compute comment count (number of conversations for this product)
                            $pid = (int)$p['id'];
                            $cntRow = $conn->query("SELECT COUNT(DISTINCT conversation_id) AS cnt FROM product_conversations WHERE product_id = $pid AND conversation_id > 0")->fetch_assoc();
                            $comment_count = $cntRow ? (int)$cntRow['cnt'] : 0;
                        ?>
                        <div class="swiper-slide">
                            <div class="product-card shadow-sm">
                                <img src="<?= base_url($p['image_url']) ?>" alt="<?= htmlspecialchars($p['name']) ?>">
                                <h6 class="mt-2"><?= htmlspecialchars($p['name']) ?></h6>
                                <p class="mb-1">Price: <?= number_format((float)$p['sale_price'],2) ?></p>

                                <div class="d-flex gap-2 mt-2">
                                    <a href="<?= base_url('messages.php?start='.$pid) ?>" class="btn btn-sm btn-primary flex-grow-1">Comment</a>
                                    <div class="btn btn-sm btn-outline-secondary">
                                        Comments: <?= $comment_count ?>
                                    </div>
                                </div>

                                <?php if ($logged_in): ?>
                                <div class="text-muted small mt-2">Login to add private messages</div>
                                <?php endif; ?>

                            </div>
                        </div>
                        <?php endforeach; ?>

                    </div>
                </div>

            </div>
        </div>
        <?php endforeach; ?>

    </div>
</div>

</div>
<div id="lightboxOverlay" style="display:none;position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.85);z-index:2000;justify-content:center;align-items:center;display:flex;">
    <span id="lightboxClose" style="position:absolute;top:20px;right:20px;font-size:32px;color:white;cursor:pointer;">&times;</span>
    <img id="lightboxImg" src="" style="max-width:90%;max-height:90%;border-radius:8px;box-shadow:0 0 15px #000;">
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.js"></script>
<script>
// Initialize nested swipers
document.querySelectorAll('.horizontalSwiper').forEach(function(sw) {
    new Swiper(sw, {
        direction:'horizontal',
        slidesPerView:1,
        spaceBetween:10,
        loop:false,
    });
});
new Swiper('.verticalSwiper', {
    direction:'vertical',
    slidesPerView:1,
    spaceBetween:20,
    loop:false,
    mousewheel:true,
});
</script>
<script>
// Lightbox functionality
const lightbox = document.getElementById('lightboxOverlay');
const lightboxImg = document.getElementById('lightboxImg');
const closeBtn = document.getElementById('lightboxClose');

document.querySelectorAll('.product-card img').forEach(img=>{
    img.addEventListener('click', ()=>{
        lightboxImg.src = img.src; // set full image
        lightbox.style.display = 'flex'; // show lightbox
    });
});

// Close button
closeBtn.addEventListener('click', ()=>{
    lightbox.style.display = 'none';
});

// Close when clicking outside the image
lightbox.addEventListener('click', e=>{
    if(e.target === lightbox) lightbox.style.display='none';
});
</script>


</body>
</html>
