<?php
// get_comment_counts.php
// Returns JSON: { "product_id": count, ... }

header('Content-Type: application/json');
include 'db.php';

// We'll return counts for products that are active (status=1).
// This is intentionally simple and should be fast if product_responses has an index on product_id.

$sql = "
    SELECT p.id AS product_id, COUNT(pr.id) AS cnt
    FROM products p
    LEFT JOIN product_responses pr ON pr.product_id = p.id
    WHERE p.status = 1
    GROUP BY p.id
";
$res = $conn->query($sql);
$out = [];
if ($res) {
    while ($row = $res->fetch_assoc()) {
        $out[(int)$row['product_id']] = (int)$row['cnt'];
    }
}

// Return JSON
echo json_encode($out);
