<?php
// fetch_messages.php
session_start();
include 'db.php';
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode([]); exit;
}
$user_id = (int)$_SESSION['user_id'];
$conversation_id = isset($_GET['conversation_id']) ? (int)$_GET['conversation_id'] : 0;
if (!$conversation_id) { echo json_encode([]); exit; }

// Security: ensure user is a participant
$chk = $conn->prepare("SELECT 1 FROM product_conversations WHERE conversation_id = ? AND (sender_id = ? OR receiver_id = ?) LIMIT 1");
$chk->bind_param("iii", $conversation_id, $user_id, $user_id);
$chk->execute();
$reschk = $chk->get_result();
if (!$reschk->fetch_assoc()) { echo json_encode([]); exit; }
$chk->close();

$stmt = $conn->prepare("
    SELECT message_id, conversation_id, product_id, sender_id, receiver_id, message, DATE_FORMAT(created_at, '%d %b %H:%i') AS created_at
    FROM product_conversations
    WHERE conversation_id = ?
    ORDER BY message_id ASC
");
$stmt->bind_param("i", $conversation_id);
$stmt->execute();
$res = $stmt->get_result();
$messages = [];
while ($row = $res->fetch_assoc()) $messages[] = $row;
$stmt->close();

echo json_encode($messages);
