<?php
// Include DB connection
include 'db.php';

// Get all tables
$tables = [];
$result = $conn->query("SHOW TABLES");
while ($row = $result->fetch_array()) {
    $tables[] = $row[0];
}

// Handle form submission
$selectedTables = isset($_POST['tables']) ? $_POST['tables'] : [];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Table Descriptions</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 30px; }
        form { margin-bottom: 30px; }
        .table-list { display: flex; flex-wrap: wrap; gap: 15px; }
        label { display: flex; align-items: center; gap: 6px; background: #f8f9fa; padding: 8px 12px; border-radius: 6px; cursor: pointer; border: 1px solid #ddd; }
        label:hover { background: #e9ecef; }
        table { border-collapse: collapse; margin-top: 15px; width: 100%; max-width: 900px; }
        th, td { border: 1px solid #ccc; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        h2 { color: #333; margin-top: 40px; }
        .submit-btn { padding: 10px 20px; background: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; }
        .submit-btn:hover { background: #0056b3; }
    </style>
</head>
<body>

<h1>📋 Select Tables to Describe</h1>

<form method="POST">
    <div class="table-list">
        <?php foreach ($tables as $table): ?>
            <label>
                <input type="checkbox" name="tables[]" value="<?= htmlspecialchars($table) ?>" 
                       <?= in_array($table, $selectedTables) ? 'checked' : '' ?>>
                <?= htmlspecialchars($table) ?>
            </label>
        <?php endforeach; ?>
    </div>
    <br>
    <button type="submit" class="submit-btn">Show Description</button>
</form>

<?php
// Display DESCRIBE results if any table selected
if (!empty($selectedTables)) {
    foreach ($selectedTables as $table) {
        echo "<h2>Table: " . htmlspecialchars($table) . "</h2>";
        $describe = $conn->query("DESCRIBE `$table`");

        if ($describe && $describe->num_rows > 0) {
            echo '<table>';
            echo '<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>';
            while ($col = $describe->fetch_assoc()) {
                echo '<tr>';
                echo '<td>'.htmlspecialchars($col['Field']).'</td>';
                echo '<td>'.htmlspecialchars($col['Type']).'</td>';
                echo '<td>'.htmlspecialchars($col['Null']).'</td>';
                echo '<td>'.htmlspecialchars($col['Key']).'</td>';
                echo '<td>'.htmlspecialchars($col['Default']).'</td>';
                echo '<td>'.htmlspecialchars($col['Extra']).'</td>';
                echo '</tr>';
            }
            echo '</table>';
        } else {
            echo "<p>No columns found for this table.</p>";
        }
    }
}
$conn->close();
?>

</body>
</html>
