<?php
include 'db.php';

// Range
$start_id = 4;
$end_id   = 33;

// Products to assign per seller
$limit_per_seller = 5;

// Expiry date fixed
$expiry = "2026-11-20 15:30:00";

for ($seller = $start_id; $seller <= $end_id; $seller++) {

    // Fetch products that still need seller assignment
    $qry = "SELECT id FROM products 
            WHERE seller_id = 0 
            ORDER BY id ASC 
            LIMIT $limit_per_seller";

    $res = $conn->query($qry);

    if ($res->num_rows == 0) {
        echo "No more products left to assign.<br>";
        break;
    }

    while ($row = $res->fetch_assoc()) {
        $product_id = $row['id'];

        // Update each product
        $update = "UPDATE products 
                   SET seller_id = $seller,
                       expiry_at = '$expiry'
                   WHERE id = $product_id";

        $conn->query($update);

        echo "Assigned Product ID $product_id → Seller $seller<br>";
    }
}

echo "<hr>Completed assignment!";
?>
