<?php
// session_start();
include 'db.php';

$errors = [];
$success = '';

// --- AUTO-BASE DETECTION ---
$base_folder = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/');
function base_url($path = '') {
    global $base_folder;
    return $base_folder . '/' . ltrim($path, '/');
}
// --- END AUTO-BASE DETECTION ---

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $phone = trim($_POST['phone']);
    $is_seller = isset($_POST['is_seller']) ? 1 : 0;

    if (!$name || !$phone) {
        $errors[] = "Name and phone are required.";
    }

    if (empty($errors)) {
        // Generate random key (not sent automatically, admin will send)
        $key_length = $is_seller ? 6 : 5;
        $chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        $key = '';
        for ($i=0; $i<$key_length; $i++) $key .= $chars[rand(0, strlen($chars)-1)];

        // Default upload limit = 5
        $upload_limit = 5;

        // Insert into registration table
        $stmt = $conn->prepare("
            INSERT INTO registration 
            (name, phone, code, verified, created_at, is_seller, upload_limit) 
            VALUES (?, ?, ?, 0, NOW(), ?, ?)
        ");
        $stmt->bind_param("sssii", $name, $phone, $key, $is_seller, $upload_limit);

        if ($stmt->execute()) {
            $success = "Registered successfully. Your key will be sent on your number withing 3 hours.";
        } else {
            $errors[] = "Database error: " . $conn->error;
        }
        $stmt->close();
    }
}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Registration</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background:#f8f9fa; }
.card { max-width:400px; margin:auto; margin-top:50px; }
</style>
</head>
<body>

<div class="card p-4 shadow-sm">
    <h4 class="mb-3 text-center">Register</h4>

    <?php if($errors): ?>
        <div class="alert alert-danger">
            <?php foreach($errors as $e) echo htmlspecialchars($e)."<br>"; ?>
        </div>
    <?php endif; ?>

    <?php if($success): ?>
        <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
    <?php endif; ?>

    <form method="post">
        <div class="mb-2">
            <input type="text" name="name" class="form-control" placeholder="Your Name" required>
        </div>
        <div class="mb-2">
            <input type="text" name="phone" class="form-control" placeholder="Phone Number" required>
        </div>
        <div class="form-check mb-2">
            <input type="checkbox" name="is_seller" class="form-check-input" id="sellerCheck">
            <label class="form-check-label" for="sellerCheck">Register as Seller</label>
        </div>
        <button class="btn btn-primary w-100">Register</button>
    </form>

    <div class="text-center mt-2">
        <a href="<?= base_url('login') ?>">Already registered? Login</a>
    </div>
</div>

</body>
</html>
