<?php
session_start();
include 'db.php';

// Get already loaded seller slugs from POST
$loadedSlugs = $_POST['loaded'] ?? [];
$loadedSlugs = array_map(function($slug){ return $db->real_escape_string($slug); }, $loadedSlugs);

// Fetch random sellers not already loaded
if (!empty($loadedSlugs)) {
    $where = "AND slug NOT IN ('" . implode("','", $loadedSlugs) . "')";
} else {
    $where = "";
}

$sellers = [];
$sellerResult = $conn->query("SELECT id, name, slug FROM registration WHERE is_seller=1 AND seller_active=1 $where ORDER BY RAND() LIMIT 3");
while ($seller = $sellerResult->fetch_assoc()) {
    $stmt = $conn->prepare("SELECT id, name, sale_price, image_url, slug FROM products WHERE seller_id=? AND status=1 ORDER BY RAND()");
    $stmt->bind_param("i", $seller['id']);
    $stmt->execute();
    $prodResult = $stmt->get_result();
    $products = [];
    while ($p = $prodResult->fetch_assoc()) $products[] = $p;
    $stmt->close();

    if (!empty($products)) {
        $seller['products'] = $products;
        $sellers[] = $seller;
    }
}

// Output HTML slides
foreach ($sellers as $seller): ?>
<div class="swiper-slide" data-slug="<?= htmlspecialchars($seller['slug']) ?>">
    <div class="container py-3">
        <div class="category-title"><?= htmlspecialchars($seller['name']) ?></div>
        <div class="swiper horizontalSwiper">
            <div class="swiper-wrapper">
            <?php foreach ($seller['products'] as $p):
                $pid = (int)$p['id'];
                $cntRow = $conn->query("SELECT COUNT(DISTINCT conversation_id) AS cnt FROM product_conversations WHERE product_id=$pid AND conversation_id>0")->fetch_assoc();
                $comment_count = $cntRow ? (int)$cntRow['cnt'] : 0;
            ?>
                <div class="swiper-slide">
                    <div class="d-flex flex-column h-100">
                        <div class="product-card shadow-sm mb-2">
                            <img src="<?= $p['image_url'] ?>" alt="<?= htmlspecialchars($p['name']) ?>">
                            <h6 class="mt-2"><?= htmlspecialchars($p['name']) ?></h6>
                            <p class="mb-1">Price: <?= number_format((float)$p['sale_price'],2) ?></p>
                            <div class="d-flex gap-2 mt-2">
                                <a href="<?= base_url('messages.php?start='.$pid) ?>" class="btn btn-sm btn-primary flex-grow-1">Comment</a>
                                <div class="btn btn-sm btn-outline-secondary">Comments: <?= $comment_count ?></div>
                            </div>
                        </div>
                        <div class="bottom-image flex-grow-1">
                            <img src="isforslide1.PNG" alt="Extra Image" class="w-100 h-100 object-fit-cover rounded">
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>
<?php endforeach; ?>
