<?php
// mark_gallery.php
session_start();
include 'db.php';

// --- AUTO-BASE DETECTION ---
$base_folder = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/');
function base_url($path = '') {
    global $base_folder;
    return $base_folder . '/' . ltrim($path, '/');
}

// Auto mark expired
$conn->query("UPDATE products SET status=0 WHERE expiry_at <= NOW() AND status=1");

// --- USER INFO ---
$logged_in = isset($_SESSION['user_id']);
$user_name = $_SESSION['user_name'] ?? '';
$is_seller = $_SESSION['is_seller'] ?? 0;

// --- CONFIG ---
$BATCH = 5;
$ajax = (isset($_GET['ajax']) && $_GET['ajax'] == '1') || (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest');

// --- FETCH SELLERS WITH PRODUCTS ---
function fetch_sellers_with_products($conn, $limit = 5, $exclude_ids = []) {
    $placeholders = '';
    $params = [];
    $types = '';
    if (!empty($exclude_ids)) {
        $placeholders = implode(',', array_fill(0, count($exclude_ids), '?'));
    }

    if ($placeholders) {
        $sql = "SELECT r.id, r.name, r.slug
                FROM registration r
                WHERE r.is_seller = 1 AND r.seller_active = 1
                  AND NOT r.id IN ($placeholders)
                  AND EXISTS (SELECT 1 FROM products p WHERE p.seller_id = r.id AND p.status = 1)
                ORDER BY RAND()
                LIMIT ?";
    } else {
        $sql = "SELECT r.id, r.name, r.slug
                FROM registration r
                WHERE r.is_seller = 1 AND r.seller_active = 1
                  AND EXISTS (SELECT 1 FROM products p WHERE p.seller_id = r.id AND p.status = 1)
                ORDER BY RAND()
                LIMIT ?";
    }

    $stmt = $conn->prepare($sql);
    if ($stmt === false) return [];

    if ($placeholders) {
        $types = str_repeat('i', count($exclude_ids)) . 'i';
        $params = array_merge($exclude_ids, [$limit]);
        $stmt->bind_param($types, ...$params);
    } else {
        $stmt->bind_param('i', $limit);
    }

    $stmt->execute();
    $res = $stmt->get_result();
    $sellers = [];
    while ($r = $res->fetch_assoc()) $sellers[] = $r;
    $stmt->close();

    $out = [];
    foreach ($sellers as $s) {
        $pstmt = $conn->prepare("SELECT id, name, sale_price, image_url, slug FROM products WHERE seller_id = ? AND status = 1 ORDER BY RAND()");
        if (!$pstmt) continue;
        $pstmt->bind_param("i", $s['id']);
        $pstmt->execute();
        $pres = $pstmt->get_result();
        $products = [];
        while ($p = $pres->fetch_assoc()) $products[] = $p;
        $pstmt->close();

        if (!empty($products)) {
            $s['products'] = $products;
            $out[] = $s;
        }
    }

    return $out;
}

// --- AJAX: LOAD MORE SELLERS ---
if ($ajax && isset($_GET['load_more']) && $_GET['load_more'] == '1') {

    error_reporting(E_ALL);
    ini_set('display_errors', 1);

    $exclude_raw = $_POST['exclude'] ?? '';
    $exclude_ids = [];
    if ($exclude_raw !== '') {
        if (strpos($exclude_raw, '[') === 0) {
            $decoded = json_decode($exclude_raw, true);
            if (is_array($decoded)) $exclude_ids = array_map('intval', $decoded);
        } else {
            $parts = array_filter(array_map('trim', explode(',', $exclude_raw)));
            foreach ($parts as $p) if (is_numeric($p)) $exclude_ids[] = (int)$p;
        }
    }

    $more_sellers = fetch_sellers_with_products($conn, $BATCH, $exclude_ids);

    ob_start();
    foreach ($more_sellers as $seller):
        $seller_id = (int)$seller['id'];
    ?>
    <div class="swiper-slide seller-slide" data-seller-id="<?= $seller_id ?>" data-slug="<?= htmlspecialchars($seller['slug']) ?>">
        <div class="container py-3">
            <div class="category-title"><?= htmlspecialchars($seller['name']) ?></div>
            <div class="swiper horizontalSwiper">
                <div class="swiper-wrapper">
                    <?php foreach ($seller['products'] as $p): 
                        $pid = (int)$p['id'];
                        $cntRow = $conn->query("SELECT COUNT(DISTINCT conversation_id) AS cnt FROM product_conversations WHERE product_id = $pid AND conversation_id > 0")->fetch_assoc();
                        $comment_count = $cntRow ? (int)$cntRow['cnt'] : 0;
                    ?>
                    <div class="swiper-slide" data-slug="<?= htmlspecialchars($seller['slug']) ?>">
                        <div class="d-flex flex-column h-100">
                            <div class="product-card shadow-sm mb-2">
                                <img src="<?= htmlspecialchars($p['image_url']) ?>" alt="<?= htmlspecialchars($p['name']) ?>">
                                <h6 class="mt-2"><?= htmlspecialchars($p['name']) ?></h6>
                                <p class="mb-1">Price: <?= number_format((float)$p['sale_price'],2) ?></p>
                                <div class="d-flex gap-2 mt-2">
                                    <a href="<?= base_url('messages.php?start='.$pid) ?>" class="btn btn-sm btn-primary flex-grow-1">Comment</a>
                                    <div class="btn btn-sm btn-outline-secondary">Comments: <?= $comment_count ?></div>
                                </div>
                                <?php if (!$logged_in): ?>
                                <div class="text-muted small mt-2">Login to add private messages</div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
    <?php
    endforeach;

    $html = ob_get_clean();
    header('Content-Type: text/html; charset=utf-8');
    echo $html;
    exit;
}

// --- MAIN PAGE: INITIAL SELLERS ---
$jumpSlug = $_GET['seller'] ?? '';
$initial_sellers = [];
$excluded_ids = [];

// Load seller by slug if provided
if ($jumpSlug) {
    $stmt = $conn->prepare("SELECT id, name, slug FROM registration WHERE slug=? AND is_seller=1 AND seller_active=1 LIMIT 1");
    $stmt->bind_param("s", $jumpSlug);
    $stmt->execute();
    $res = $stmt->get_result();
    $sellerRow = $res->fetch_assoc();
    $stmt->close();

    if ($sellerRow) {
        $pstmt = $conn->prepare("SELECT id, name, sale_price, image_url, slug FROM products WHERE seller_id=? AND status=1 ORDER BY created_at DESC");
        $pstmt->bind_param("i", $sellerRow['id']);
        $pstmt->execute();
        $pres = $pstmt->get_result();
        $products = [];
        while ($p = $pres->fetch_assoc()) $products[] = $p;
        $pstmt->close();

        if (!empty($products)) {
            $sellerRow['products'] = $products;
            $initial_sellers[] = $sellerRow;
            $excluded_ids[] = (int)$sellerRow['id'];
        }
    }
}

// If no slug or slug not found, load first random sellers
if (empty($initial_sellers)) {
    $initial_sellers = fetch_sellers_with_products($conn, 5, []);
}

// Add all initially-loaded seller IDs to $excluded_ids
foreach ($initial_sellers as $s) {
    $excluded_ids[] = (int)$s['id'];
}

$more_sellers = fetch_sellers_with_products($conn, $BATCH, $excluded_ids);
$sellers = array_merge($initial_sellers, $more_sellers);
$jumpIndex = 0;
?>

<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Product Gallery</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.css" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
<style>
body{background:#f8f9fa;margin:0;padding:0;}
.swiper{width:100%;height:100vh;}
.product-card{background:#fff;border-radius:.5rem;padding:.5rem;text-align:center;}
.product-card img{width:100%;max-height:300px;object-fit:cover;border-radius:.5rem;}
.category-title{font-weight:bold;font-size:1.1rem;margin-bottom:.5rem;}
.load-more-wrap{text-align:center;margin:12px 0;}
#lightboxOverlay{position:fixed;display:none;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,.85);z-index:2000;justify-content:center;align-items:center;}
#lightboxOverlay img{max-width:90%;max-height:90%;border-radius:8px;box-shadow:0 0 15px #000;}
</style>
</head>
<body>

<!-- Inject loaded IDs from PHP -->
<script>
var loadedSellerIds = <?php echo json_encode(array_values(array_unique($excluded_ids))); ?>;
console.log('initial loadedSellerIds (from PHP):', loadedSellerIds);
</script>

<div class="container py-3">
    <div class="swiper verticalSwiper">
        <div class="swiper-wrapper" id="verticalWrapper">
            <?php foreach($sellers as $seller):
                $sid = (int)$seller['id'];
            ?>
            <div class="swiper-slide seller-slide" data-seller-id="<?= $sid ?>" data-slug="<?= htmlspecialchars($seller['slug']) ?>">
                <div class="container py-3">
                    <div class="category-title"><?= htmlspecialchars($seller['name']) ?></div>
                    <div class="swiper horizontalSwiper">
                        <div class="swiper-wrapper">
                            <?php foreach($seller['products'] as $p):
                                $pid = (int)$p['id'];
                                $cntRow = $conn->query("SELECT COUNT(DISTINCT conversation_id) AS cnt FROM product_conversations WHERE product_id=$pid AND conversation_id>0")->fetch_assoc();
                                $comment_count = $cntRow ? (int)$cntRow['cnt'] : 0;
                            ?>
                            <div class="swiper-slide" data-slug="<?= htmlspecialchars($seller['slug']) ?>">
                                <div class="d-flex flex-column h-100">
                                    <div class="product-card shadow-sm mb-2">
                                        <img src="<?= htmlspecialchars($p['image_url']) ?>">
                                        <h6 class="mt-2"><?= htmlspecialchars($p['name']) ?></h6>
                                        <p class="mb-1">Price: <?= number_format((float)$p['sale_price'],2) ?></p>
                                        <div class="d-flex gap-2 mt-2">
                                            <a href="<?= base_url('messages.php?start='.$pid) ?>" class="btn btn-sm btn-primary flex-grow-1">Comment</a>
                                            <div class="btn btn-sm btn-outline-secondary">Comments: <?= $comment_count ?></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>

    <div class="load-more-wrap">
        <div id="loadMoreWrap" style="position: fixed; bottom: 10px; left: 50%; transform: translateX(-50%); z-index: 999;">
            <button id="loadMoreBtn" class="btn btn-outline-primary">Load more sellers</button>
        </div>
    </div>
</div>

<div id="lightboxOverlay">
    <span id="lightboxClose" style="position:absolute;top:20px;right:20px;font-size:32px;color:white;cursor:pointer;">&times;</span>
    <img id="lightboxImg" src="">
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.js"></script>

<script>
window.addEventListener('load', ()=>{

    console.log('loadedSellerIds at load:', loadedSellerIds);

    function initHorizontalSwipers(container){
        (container||document).querySelectorAll('.horizontalSwiper').forEach(sw=>{
            if(sw.dataset.inited==='1') return;
            new Swiper(sw,{direction:'horizontal',slidesPerView:1,spaceBetween:10,loop:false});
            sw.dataset.inited='1';
        });
    }
    initHorizontalSwipers();

    const verticalWrapper = document.getElementById('verticalWrapper');
    const verticalSwiper = new Swiper('.verticalSwiper',{
        direction:'vertical',slidesPerView:1,spaceBetween:20,loop:false,mousewheel:true,observer:true,observeParents:true
    });

    function attachLightbox(container){
        (container||document).querySelectorAll('.product-card img').forEach(img=>{
            if(img.dataset.lb==='1') return;
            img.addEventListener('click', ()=> {
                document.getElementById('lightboxImg').src = img.src;
                document.getElementById('lightboxOverlay').style.display = 'flex';
            });
            img.dataset.lb='1';
        });
    }
    attachLightbox();

    document.getElementById('lightboxClose').addEventListener('click', ()=>{document.getElementById('lightboxOverlay').style.display='none';});
    document.getElementById('lightboxOverlay').addEventListener('click', e=>{if(e.target===document.getElementById('lightboxOverlay')) document.getElementById('lightboxOverlay').style.display='none';});

    // --- LOAD MORE ---
    const loadMoreBtn = document.getElementById('loadMoreBtn');
    loadMoreBtn.addEventListener('click', ()=>{
        loadMoreBtn.disabled=true;
        loadMoreBtn.textContent='Loading...';
        console.log('sending exclude ->', loadedSellerIds);

        fetch(window.location.pathname+'?ajax=1&load_more=1',{
            method:'POST',
            headers:{'Content-Type':'application/x-www-form-urlencoded'},
            body:'exclude='+encodeURIComponent(JSON.stringify(loadedSellerIds))
        }).then(r=>r.text()).then(html=>{
            console.log('AJAX response length:', html.length);
            if(!html.trim()){
                loadMoreBtn.textContent='No more sellers';
                loadMoreBtn.disabled=true;
                return;
            }
            const tmp=document.createElement('div'); tmp.innerHTML=html;
            const newSlides=tmp.querySelectorAll('.seller-slide');
            newSlides.forEach(ns=>{
                verticalWrapper.insertAdjacentHTML("beforeend",ns.outerHTML);
                const sid=parseInt(ns.dataset.sellerId||0);
                if(sid && !loadedSellerIds.includes(sid)) loadedSellerIds.push(sid);
            });
            initHorizontalSwipers(verticalWrapper);
            attachLightbox(verticalWrapper);
            verticalSwiper.update();
            loadMoreBtn.disabled=false;
            loadMoreBtn.textContent='Load more sellers';
            console.log('loadedSellerIds after append ->', loadedSellerIds);
        }).catch(err=>{
            console.error(err);
            loadMoreBtn.disabled=false;
            loadMoreBtn.textContent='Load more sellers';
            alert('Failed to load more sellers.');
        });
    });
});
</script>

</body>
</html>
