<!DOCTYPE html>
<html>
<head>
<title>Change Code</title>

<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">

<?php
include 'db.php'; // your database connection file

$message = "";
$success = false;

if(isset($_POST['change_code'])){
    $phone     = trim($conn->real_escape_string($_POST['phone']));
    $old_code  = trim($conn->real_escape_string($_POST['old_code']));
    $new_code  = trim($conn->real_escape_string($_POST['new_code']));

    // Basic validation
    if(empty($phone) || empty($old_code) || empty($new_code)){
        $message = "<div class='error'>All fields are required!</div>";
    } elseif(strlen($new_code) > 10){
        $message = "<div class='error'>Code must be max 10 characters</div>";
    } else {
        // Check user exists
        $check = $conn->query("SELECT id, code, is_seller FROM registration WHERE phone='$phone' LIMIT 1");
        if($check->num_rows == 1){
            $user = $check->fetch_assoc();
            if($user['code'] !== $old_code){
                $message = "<div class='error'>Old code is incorrect.</div>";
            } else {
                // Check if new code already exists
                $checkCode = $conn->query("SELECT id FROM registration WHERE code='$new_code' LIMIT 1");
                if($checkCode->num_rows > 0){
                    $message = "<div class='error'>This new code is already in use. Choose another.</div>";
                } else {
                    // Update code
                    $update = $conn->query("UPDATE registration SET code='$new_code' WHERE phone='$phone'");
                    if($update){
                        $success = true; // triggers toast
                        $message = "<div class='success'>
                            ✅ Code changed successfully! <br>
                            Your seller status: <b>".($user['is_seller'] == 1 ? 'Seller' : 'Normal User')."</b>
                        </div>";
                    } else {
                        $message = "<div class='error'>Database error. Try again!</div>";
                    }
                }
            }
        } else {
            $message = "<div class='error'>Phone number not found!</div>";
        }
    }
}
?>

<style>
*{
    box-sizing:border-box;
    -webkit-tap-highlight-color: transparent;
}

body {
    margin: 0;
    padding: 0;
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Arial, sans-serif;
    background: linear-gradient(135deg, #f1f2f6, #dfe4ea);
}

.container {
    width: 100%;
    max-width: 420px;
    min-height: 100vh;
    background: white;
    margin: auto;
    padding: 30px 22px 40px;
    display: flex;
    flex-direction: column;
    justify-content: center;
}

h2 {
    text-align: center;
    margin-bottom: 25px;
    font-size: 22px;
    letter-spacing: .4px;
}

form{
    width:100%;
}

input {
    width: 100%;
    padding: 15px;
    margin-bottom: 16px;
    border: 1px solid #ced6e0;
    border-radius: 12px;
    font-size: 16px;
    outline:none;
}

input:focus{
    border-color: #2ecc71;
    box-shadow: 0 0 0 2px rgba(46,204,113,0.1);
}

button {
    width: 100%;
    padding: 16px;
    background: #2ecc71;
    border: none;
    color: white;
    font-size: 17px;
    font-weight: 600;
    border-radius: 14px;
    cursor: pointer;
    margin-top: 5px;
}

button:active{
    transform: scale(0.97);
    background:#27ae60;
}

/* messages */

.success, .error{
    padding: 14px;
    margin-bottom: 18px;
    border-radius: 12px;
    font-size: 14px;
}

.success{
    background: #eafaf1;
    border-left: 6px solid #2ecc71;
    color: #1e8449;
}

.error{
    background: #fdecea;
    border-left: 6px solid #e74c3c;
    color: #922b21;
}

/* Seller link */
.seller-link{
    text-align:center;
    margin-top:20px;
}
.seller-link a{
    display:inline-block;
    padding:12px 18px;
    background:#2980b9;
    color:white;
    text-decoration:none;
    font-weight:600;
    border-radius:12px;
}

/* LARGE SCREEN FIX */
@media (min-width: 768px) {
    .container{
        min-height:auto;
        border-radius:20px;
        margin-top:60px;
        box-shadow: 0 20px 50px rgba(0,0,0,0.08);
    }
}

/* TOAST MESSAGE */
.toast {
    visibility: hidden;
    min-width: 260px;
    max-width: 90%;
    background: #2ecc71;
    color: white;
    text-align: center;
    border-radius: 10px;
    padding: 14px 20px;
    position: fixed;
    z-index: 999;
    left: 50%;
    bottom: 30px;
    transform: translateX(-50%);
    font-size: 15px;
    font-weight: 600;
    box-shadow: 0 10px 25px rgba(0,0,0,0.15);
}

.toast.show {
    visibility: visible;
    animation: fadein 0.4s, fadeout 0.4s 2.6s;
}

@keyframes fadein {
    from { bottom: 0; opacity: 0; }
    to { bottom: 30px; opacity: 1; }
}

@keyframes fadeout {
    from { bottom: 30px; opacity: 1; }
    to { bottom: 0; opacity: 0; }
}

</style>
</head>
<body>

<div class="container">

    <h2>Change Your Code</h2>

    <?php echo $message; ?>

    <form method="POST">

        <input 
            type="tel" 
            name="phone" 
            placeholder="Enter phone number"
            inputmode="numeric"
            required
        >

        <input 
            type="text" 
            name="old_code" 
            placeholder="Enter old code" 
            required
        >

        <input 
            type="text" 
            name="new_code" 
            maxlength="10" 
            placeholder="Enter new code (max 10)" 
            required
        >

        <button type="submit" name="change_code">
            Change Code
        </button>

    </form>

    

</div>
<div id="toast" class="toast">
✅ Your code has been changed successfully!
</div>

<?php if(isset($success) && $success === true){ ?>
<script>
    let toast = document.getElementById("toast");
    toast.className = "toast show";

    setTimeout(function(){
        toast.className = toast.className.replace("show", "");
    }, 3000);
</script>
<?php } ?>

</body>
</html>
